
;***************
;**** Code *****
;***************
.AppWin     db   0
.DskPrzN    db   2
.SysPrzN    db   3
.WinDatPrz  equ  3

.V_App_Control_ID		db	0
.V_App_Control_Addr		dw	0
.V_App_Form_ID			db	0
.V_App_Form_Addr		dw 	0
.V_App_Action_ID		db	0
.V_App_OS_Form			db  0
.V_App_In_Use			db 	0

.AppPrz:
;**** Open Primary Window ****
		call	SymStudio_StringMemory
		ld		a,SyB_StartForm					;**** Form to Open first
		call	SyB_Studio_WindowOpen			;**** Form Opener
		;**** Sets up the Timer Stack ****
		ld		hl,SyStudio_TimerStack
		ld		a,(AppBnkNum)
		ld		e,7
		call	SyKernel_MTADDT
  		jp      c,SyB_Studio_End
       	ld      (PrgPstSpz+AppCodBeg),a
	#IF USENET
		call 	Syb_Net_Init					;**** Start Network Daemon if needed
	#ENDIF	
		inclib	SYB.FLOAT.ROUTINES
;****************************************
;**** Main Application Control Loop *****
;****************************************
.SyB_Control_Loop:
		ld		a,(V_App_In_Use)
		And		a
		jr		nz,SyB_Control_Loop_1
		;****  Wait for App Message
		rst		#30
		ld		a,(AppPrzN)
       	db		#dd:ld l,a
		db		#dd:ld h,-1
 		ld		iy,AppMsgB
		rst		#18
		Or		a
		db		#dd:dec l
		jr		nz,SyB_Control_Loop_2
	#IF USENET	
		ld 		a,(SyNet_PrcID)
		db 		#dd:cp h
		jp 		z,SyB_Net_Event
	#ENDIF	
		ld		a,(AppMsgB+0)
		Or		a
		jp		z,SyB_Studio_End
		scf

		cp		MSR_DSK_WCLICK
		jp		z,SyB_Event_Control_1
		cp		MSR_DSK_DSKSRV
		jp		z,SyB_Event_Control_1
		cp		166								;**** Resize window
		jp		z,SyB_Event_Resize_1
.SyB_Control_Loop_2:
		ld		a,(SyB_Studio_FormNo)			;**** A = SymStudio Window Number			
		ld		c,4								;**** C = 4 = Main loop
		call	SyB_Call_Form_Event
.SyB_Control_Loop_1:
		Xor		a
		ld		(V_App_In_Use),a
		jr		SyB_Control_Loop
		
.SyB_Event_Control_1		
		ld		a,(Event_Type)	  
 		cp		DSK_ACT_CONTENT
 		jp		z,App_Content
 		cp		DSK_ACT_TOOLBAR
 		jp		z,App_Tool		
		cp		DSK_ACT_CLOSE
		jp		z,SyB_Studio_End
		cp		DSK_ACT_MENU
 		jp		z,App_Menu

		cp		DSK_ACT_KEY
		jp		z,App_Key
		jp		SyB_Control_Loop_1
;****              ****		
;**** Resize Event ****
;****              ****
.SyB_Event_Resize_1:
		ld		a,(SyB_Studio_FormNo)			;**** A = SymStudio Window Number			
		ld		c,3								;**** C = 3 = Resize event
		call	SyB_Call_Form_Event
		jp		SyB_Control_Loop_1			

;*********************
;**** Key Control ****
;*********************
.App_Key:
		ld		a,(AppMsgB+4)
		and		%10000000
		jp		z,App_Content
		jp		SyB_Control_Loop_1

;**********************
;**** Menu Control ****
;**********************
.App_Menu:
		ld		a,1
		ld		(V_App_In_Use),a
		ld		hl,(AppMsgB+8)
		Xor		a
		cp		h
		jr		nz,App_Call_Set12
		cp		l
		jp		z,SyB_Control_Loop_1
.App_Call_Set12
		Xor		a
		ld		(V_App_In_Use),a
		push	ix
		push	iy
		ld		(App_Call_Set2+1),hl
.App_Call_Set2:
		call	0
		pop		iy
		pop		ix		
		jp		SyB_Control_Loop

		
;****************************************
;**** User has clicked on one Tool Control ****
;****************************************		
.App_Tool:
		ld		a,(Event_Form_ID)
		ld		c,a
		call	SyB_Get_FormNo
		ld		l,e
		ld		h,0
		add		hl,hl
		add		hl,hl	
		ld		de,ControWindowDataList
		add		hl,de
		inc		hl
		inc		hl
		Jr		App_Content2
;*****************************************
;**** User has clicked on one Control ****
;*****************************************
.App_Content:
		ld		a,(Event_Form_ID)
		ld		c,a
		call	SyB_Get_FormNo
		ld		l,e
		ld		h,0
		add		hl,hl
		add		hl,hl	
		ld		de,ControWindowDataList
		add		hl,de
.App_Content2:		
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		ld		a,(Event_Control_ID)
		ld		l,a
		ld		h,0
		add		hl,hl
		add		hl,hl
		add		hl,hl
		add		hl,hl
		add		hl,de
		ld		de,14
		add		hl,de
		ld		e,(hl)
		inc 	hl
		ld		d,(hl)
		Xor		a
		cp		e
		jp		nz,SyB_Studio_Content_Event_1
		cp		d
		jp		nz,SyB_Studio_Content_Event_1
		jp		SyB_Control_Loop
.SyB_Studio_Content_Event_1:
		Xor		a
		ld		(V_App_In_Use),a
		ld		(SyB_Studio_Content_Event_2+1),de
.SyB_Studio_Content_Event_2
		call	0		
		jp		SyB_Control_Loop		

;****                       ****		
;**** Shut down Application ****
;****                       ****		
.SyB_Studio_End
		ld		a,(Event_Form_ID)
		ld		c,a
		call	SyB_Get_FormNo
		push	de
		ld		a,e
		call	SyB_Studio_CloseForm
		pop		de
		ld		a,e
		And		a
		jp		z,SyB_Studio_End_2
		;Is Form 0 form?????
		ld		a,(SyB_Studio_FormOS)
		call	SyDesktop_WINCLS		
		jp		SyB_Control_Loop_1
		
.SyB_Studio_End_2
		ld		hl,SyB_RamBankInfo				;Start of Bank Info
		ld		b,23							;Number of Banks Possible-1
.SyB_Studio_End_90		
		cp		(hl)
		jp		z,SyB_Studio_End_99
		push 	bc
		inc		hl
		ld		a,(hl)
		inc		hl
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		inc		hl
		ld		c,(hl)
		inc		hl
		ld		b,(hl)
		inc		hl
		push	hl
		ex		de,hl
		rst 	#20:dw #811B		
		pop		hl
		pop		bc
		djnz	SyB_Studio_End_90	
		jr		SyB_Studio_End_98
.SyB_Studio_End_99		
		ld		de,6
		add		hl,de
		djnz	SyB_Studio_End_90
.SyB_Studio_End_98		
		ld		a,(AppBnkNum)
		ld		hl,(StringMemoryLoc)
		ld		bc,#800
		rst 	#20:dw #811B
		ld		a,(AppBnkNum)
		ld		hl,(SyB_File_Dialog_Pointer)
		ld		bc,#200
		rst 	#20:dw #811B	
		Xor		a	
		ld		a,(AppPrzN)
		db		#dd:ld l,a
		ld		a,(SysPrzN)
		db		#dd:ld h,a
		ld		a,(AppCodBeg+PrgPstNum)
		ld		h,a
		ld		l,MSC_SYS_PRGEND
		ld		(AppMsgB),hl
		ld		iy,AppMsgB
		rst		#10
.SyB_Studio_End_1
 		rst		#30
		jr		SyB_Studio_End_1

;****                  ****
;**** Opens a Form 0-7 ****
;****                  ****
.SyB_Studio_WindowOpen:
		ld		(SyB_Studio_FormNo),a			;**** Store the number of the Internal Window
		ld		hl,SyB_Studio_FormIDs			;**** Point to Start of Window List
		ld		e,a								;**** DE = A
		ld		d,0
		add		hl,de							;**** Calc Position	
		ld		a,(hl)							;**** Checks if exists
		push	hl
		cp		255								;
		jr		nz,SyB_Studio_WindowOpen_2		;**** If not clear then Already Open 	
		ld		a,(SyB_Studio_FormNo)			;**** A = SymStudio Window Number			
		ld		c,0								;**** C = 0 = Get data Begin Address
		call	SymStudio_GetWindowEventAddr	;**** Get Address of Window Data
		ld		e,(hl)
		inc		hl
		ld		d,(hl)							;**** DE = Address of Window Data
		ld		a,(AppBnkNum)
		call	SyDesktop_WINOPN
		jr		c,SyB_Studio_WindowOpen_2		;**** If Carry then hasn't Opened window
		pop		hl
		ld		(hl),a							;**** Store Inetrnal number into form list
		ld		a,(SyB_Studio_FormNo)			;**** A = SymStudio Window Number
		ld		c,1								;**** C = 1 = Get Open Address
		call	SyB_Call_Form_Event
		Xor		a		
		ret
.SyB_Studio_WindowOpen_2
		pop		hl
		di
.djr	jr		djr

		Xor		a
		scf
		ret
;****              ****		
;**** Close a Form ****
;****              ****
.SyB_Studio_CloseForm
		ld		(SyB_Studio_FormNo),a			;**** Store the number of the Internal Window
		ld		hl,SyB_Studio_FormIDs			;**** Point to Start of Window List
		ld		e,a								;**** DE = A
		ld		d,0
		add		hl,de							;**** Calc Position
		ld		a,(hl)							;**** Checks if exists
		cp		255
		jp		z,SyB_Studio_CloseForm_Fail
		ld		(SyB_Studio_FormOS),a
		ld		a,255
		ld		(hl),a
		ld		a,(SyB_Studio_FormNo)			;**** A = SymStudio Window Number
		ld		c,2								;**** C = 1 = Get Open Address
		call	SyB_Call_Form_Event	
		ret		
.SyB_Studio_CloseForm_Fail
		Xor		a
		ret
.SyB_Studio_FormOS:		db		0

;****                       ****
;**** Check If Event and Do ****
;****                       ****
;A=Form No C=Event To search
.SyB_Call_Form_Event:
		call	SymStudio_GetWindowEventAddr
		Xor		a
		ld		e,(hl)
		inc		hl
		ld		d,(hl)
		cp		e		
		jr		nz,SyB_Call_Form_Event_2	
		cp		d
		ret		z
.SyB_Call_Form_Event_2	
		ld		(SyB_Call_Form_Event_3+1),de
.SyB_Call_Form_Event_3
		call	0
		ret

;****                                 ****
;**** Get User Form No fro OS Form No ****
;****                                 ****
;C=OS Form Number to search for
.SyB_Get_FormNo:
	ld		b,8
	ld		e,0
	ld		hl,SyB_Studio_FormIDs
.SyB_Get_FormNo_1	
	ld		a,(hl)
	cp		c
	ret		z
	inc		e
	inc		hl
	djnz	SyB_Get_FormNo_1
	Xor		a
	ret


;**** A = Window 0-7
;**** C = 0 = Data Begin Address
;****     1 = Open Event Address
;****     2 = Close Event Address
;****     3 = Resize Event Address
;****     4 = Main Loop Address
.SymStudio_GetWindowEventAddr
	add		a				;Times 2
	add		a				;Times 4
	add		a				;Times 8
	add		a				;Times 16
	ld		hl,App_Form_List
	ld		e,a
	ld		d,0
	add		hl,de
	ld		b,0
	add		hl,bc		
	add		hl,bc
	ret

.SyB_Studio_FormNo:		db	0
.SyB_Studio_FormIDs:	db  255,255,255,255,255,255,255,255

.StringMemoryLoc:		dw	0

.SymStudio_StringMemory:
		ld		a,(AppBnkNum)
		ld		e,0
		ld		bc,#800
		rst 	#20:dw #8118
		Xor		a
		ld		(StringMemoryLoc),hl
		ld		(SyB_StrStackAddr),hl
		ld		bc,1024+506					;506 ; Cos it goes down	
		add		hl,bc
		ld		(SyB_StackAddr),hl
		ld		bc,6						;Total 1536
		add		hl,bc
		ld		(SyB_File_Name_Input),hl
		;**** Bit in Transfer RAM
		ld		a,(AppBnkNum)
		ld		e,2
		ld		bc,#200
		rst 	#20:dw #8118
		ld		(SyB_File_Dialog_Pointer),hl
	
		;Get the Application Directory
		ld		hl,SyB_CodeEnd
		inc		hl
.SymStudio_StringMemory_1		
		ld		a,(hl)
		cp		0
		jp		z,SymStudio_StringMemory_2
		cp		32
		jp		z,SymStudio_StringMemory_2
		inc		hl
		jr		SymStudio_StringMemory_1		
		;Reached end of filename
.SymStudio_StringMemory_2
		dec		hl
		ld		a,(hl)
		cp		":"
		jp		z,SymStudio_StringMemory_3
		cp      "\"
		jp		z,SymStudio_StringMemory_3		
		jp		SymStudio_StringMemory_2
		;Reached end of filename
.SymStudio_StringMemory_3
		ld		iy,(SyB_StackAddr)
		ld		de,SyB_CodeEnd
		inc		de
		ld		(iy+1),e
		ld		(iy+2),d
		Xor		a
		sbc		hl,de
		inc		hl
		ld		c,l
		ld		(iy+3),c
		ld		b,h
		ex		de,hl
		ld		de,(SyB_StrStackAddr)
		ldir
		Xor		a
		ld		(de),a
		inc		de
		ld		(SyB_StrStackAddr),de
		ld		bc,-6
		add		iy,bc
		ld		(Syb_StackAddr),iy
		ld		hl,InitDir
		call	SyB_Str_Store_2_Ram
		ld		iy,(SyB_StackAddr)
		ld		bc,6
		ld		(SyB_StackAddr),iy
		ret
		
.SyB_File_Dialog_Pointer:	dw	0		
.SyB_File_Name_Input:		dw	0
.SyB_StrStackAddr:			dw	0
.SyB_RetAddrTemp:			dw	0
.SyB_StackAddr:				dw	0
.ErrorNum:					dw	0
.ErrorPC:					dw	0
.InitDir:   				dw  InitDir_Data+3
.InitCommand: 				dw  InitCommand_Data+3
.False:						db	0
.True:						db	1
.tcounter				dw	0
		
		
;0      - String Stack		
;1024   - Stack
;1536   - File store
;.SyB_StrStackAddr:	dw	SyB_StrStackData
;.SyB_StrStackData:	ds	1024,0
;.SyB_RetAddrTemp:	dw	0
;.SyB_StackAddr:		dw	SyB_StackDataTop
;.SyB_StackData:		ds	32*6
;.SyB_StackDataTop:	ds	6

;**** This is a Purely SymStudio contruct ****
.Sys_Timer_Code:
	ld		hl,(tcounter)
	inc		hl
	ld		(tcounter),hl
	ld		hl,SyStud_TimerRoutines		;List of where all the Timer data is
.Sys_Timer_Loop_Thing
	ld		e,(hl)						;Get Address from HL into DE
	inc		hl							;
	ld		d,(hl)						;
	inc		hl							;
	Xor		a							;Check if DE=0 cos then No more Timer Check
	cp		d
	jr		nz,Sys_Keep_Going1	
	cp		e
	jr		nz,Sys_Keep_Going1
	rst		#30							;Routine Empty
	jp		Sys_Timer_Code
.Sys_Keep_Going1
	ld		a,(de)						;Check the Timer Active if not 1 ingore
	cp		1
	jr		nz,Sys_Timer_Loop_Thing
	;**** Status clear so can check if Event Happens
	inc		de							;Move onto Timer Status byte
	ld		a,(de)
	cp 		0							;If A=then Active
	jr		nz,Sys_Timer_Loop_Thing
	;**** Okay we have to Do the Counter now
	ex		de,hl
	inc		hl
	ld		c,(hl)
	inc		hl
	ld		b,(hl)
	dec		bc
	bit		7,b
	jr		nz,Sys_Timer_Timed_Out
	ld		(hl),b
	dec		hl
	ld		(hl),c
	ex		de,hl
	jr		Sys_Timer_Loop_Thing
.Sys_Timer_Timed_Out:
	inc		hl							;Moves to Low Byte of Max Word
	ld		c,(hl)						;Get
	inc		hl							;Move to High Byte of Max Word
	ld		b,(hl)						;Get
	dec		hl							;Back to Low Byte
	dec		hl							;Back to Hi Byte Counter
	ld		(hl),b						;Store
	dec		hl							;Low Byte Counter
	ld		(hl),c						;Store
	dec		hl							;Back to Status
	push	hl
	ld		a,1
	ld		(hl),a
	inc		hl
	inc		hl							;High Byte Counter
	inc		hl							;Low Byte Max
	inc		hl							;High Byte Max
	inc		hl   						;Jump Address
	ld		a,(hl)
	ld		(Sys_Timer_JumpLoc1+1),a
	inc		hl
	ld		a,(hl)
	ld		(Sys_Timer_JumpLoc1+2),a
	push	de
.Sys_Timer_JumpLoc1
	call	0
	pop		hl
	pop		de
	ld		a,0
	ld		(de),a
	jr		Sys_Timer_Loop_Thing
	
#IF USENET
.SyB_Net_Error:		dw	0
.Syb_Net_Handle:	db	255
.SyB_Net_Status_Value:	db	0
.SyB_Net_Received_Value:	dw	0
.SyB_Net_Transfered_Value:	dw 0
.SyB_Net_Send_Wait_Value:	dw 0
.SyB_Net_Event:
    ld 		a,(AppMsgB+8)
    bit 	7,a
    jr 		z,SyB_Net_Event_2
    ld 		bc,(AppMsgB+4)
    ld 		(SyB_Net_Received_Value),bc
    jr 		SyB_Net_Event_3
.SyB_Net_Event_2
    ld 		(SyB_Net_Status_Value),a
.SyB_Net_Event_3
    call 	Net_Event
    jp 		SyB_Control_Loop_1

.SySystem_PRGSRV
;******************************************************************************
;*** Name           Program_SharedService_Command
;*** Input          E  = Command type
;***                     0 = search application or shared service
;***                     1 = search, start and use shared service
;***                     2 = release shared service
;***                - if E is 0 or 1:
;***                HL = Address of the 12byte application ID string
;***                - if E is 0 or 1:
;***                A  = Ram bank (0-15) of the 12byte application ID string
;***                - if E is 2:
;*** Output         A  = Result status
;***                     0 = OK
;***                     5 = application or shared service not found (can only
;***                         occur on command type 0)
;***                     1-4=error while starting shared service; same codes
;***                         like in MSR_SYS_PRGRUN, please read there for a
;***                         detailed description
;***                - If command type was 0 or 1, and result status is 0:
;***                L  = Application ID
;***                H  = Process ID (the applications main process)
;***                - If result status is 3:
;***                L  = File manager error code
;*** Destroyed      F,BC,DE,IX,IY
;*** Description    This function can be used to find, start and release shared
;***                services or to find applications.
;***                For a detailed description please read chapter "System
;***                Manager", "Program_SharedService_Command" in the SymbOS
;***                Developer Documentation.
;******************************************************************************
        ld c,MSC_SYS_PRGSRV
        call SySystem_SendMessage
SySPSr1 call SySystem_WaitMessage
        cp MSR_SYS_PRGSRV
        jr nz,SySPSr1
        ld a,(AppMsgB+1)
        ld hl,(AppMsgB+8)
        ret		
SyNet_PrcID db 0    ;network daemon process ID
	
.Syb_Net_Init
;******************************************************************************
;*** Name           Network_Init
;*** Input          -
;*** Output         CF   = Error state (0 = ok, 1 = Network daemon not running)
;***                - if CF is 0:
;***                (SyNet_PrcID) = Network daemon process ID
;*** Destroyed      AF,BC,DE,HL,IX,IY
;*** Description    ...
;******************************************************************************
        ld e,0
        ld hl,snwdmnt
        ld a,(AppBnkNum)
        call SySystem_PRGSRV
        or a
        scf
        ret nz
        ld a,h
        ld (SyNet_PrcID),a
        or a
        ret
snwdmnt db "Network Daem"
;### SUB ROUTINES #############################################################
snwmsgi_afbcdehlixiy
        ld (AppMsgB+10),ix   ;store registers to message buffer
        ld (AppMsgB+12),iy
snwmsgi_afbcdehl
        ld (AppMsgB+04),bc
snwmsgi_afdehl
        ld (AppMsgB+06),de
snwmsgi_afhl
        ld (AppMsgB+08),hl
snwmsgi_af
        push af:pop hl
        ld (AppMsgB+02),hl
        pop hl
        ld a,(hl)               ;set command
        inc hl
        push hl
        ld (AppMsgB+0),a
        ld (snwmsg2+1),a
        ld iy,AppMsgB
        ld a,(AppPrzN)	;ld a,(App_PrcID)
        db #dd:ld l,a
        ld a,(SyNet_PrcID)
        db #dd:ld h,a
        ld (snwmsg1+2),ix
        rst #10                 ;send message
snwmsg1 ld ix,0                 ;wait for response
        rst #08
        db #dd:dec l
        jr nz,snwmsg1
        ld a,(AppMsgB)
        sub 128
snwmsg2 cp 0
        ret z
        ld	a,(AppPrzN)			;ld a,(App_PrcID)        ;wrong response code -> re-send and wait for correct one
        db #dd:ld h,a
        ld a,(SyNet_PrcID)
        db #dd:ld l,a
        rst #10
        rst #30
        jr snwmsg1
snwmsgo_afbcdehlixiy
        ld ix,(AppMsgB+10)   ;get registers from the message buffer
        ld iy,(AppMsgB+12)
        ld de,(AppMsgB+06)
snwmsgo_afbchl
        ld bc,(AppMsgB+04)
snwmsgo_afhl
        ld hl,(AppMsgB+02)
        push hl
        pop af
        ld hl,(AppMsgB+08)
        ret
#ENDIF	
	
	